'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Database
Option Explicit

Private Sub Detailbereich_Format(Cancel As Integer, FormatCount As Integer)
    'QR-Code-Formular ein-/ausschalten
    If QRjanein = False Then
        Me.Rechnung_QRcodeFormular.Visible = False
    Else
        Me.Rechnung_QRcodeFormular.Visible = True
    End If
End Sub

Private Sub Report_Activate()
    On Error Resume Next
    
    Dim Text As String
    
    Text = Me.Controls.Item("Rechnung_001_Rechnungsdaten").Controls.Item("Re_Nr")
    While InStr(Text, "\")
        Text = Left(Text, InStr(Text, "\") - 1) & "-" & Mid(Text, InStr(Text, "\") + 1)
    Wend
    While InStr(Text, "/")
        Text = Left(Text, InStr(Text, "/") - 1) & "-" & Mid(Text, InStr(Text, "/") + 1)
    Wend
    While InStr(Text, ":")
        Text = Left(Text, InStr(Text, ":") - 1) & "=" & Mid(Text, InStr(Text, ":") + 1)
    Wend
    While InStr(Text, "*")
        Text = Left(Text, InStr(Text, "*") - 1) & "_" & Mid(Text, InStr(Text, "*") + 1)
    Wend
    While InStr(Text, "?")
        Text = Left(Text, InStr(Text, "?") - 1) & "_" & Mid(Text, InStr(Text, "?") + 1)
    Wend
    While InStr(Text, """")
        Text = Left(Text, InStr(Text, """") - 1) & "'" & Mid(Text, InStr(Text, """") + 1)
    Wend
    While InStr(Text, "<")
        Text = Left(Text, InStr(Text, "<") - 1) & "_" & Mid(Text, InStr(Text, "<") + 1)
    Wend
    While InStr(Text, ">")
        Text = Left(Text, InStr(Text, ">") - 1) & "_" & Mid(Text, InStr(Text, ">") + 1)
    Wend
    While InStr(Text, "|")
        Text = Left(Text, InStr(Text, "|") - 1) & "_" & Mid(Text, InStr(Text, "|") + 1)
    Wend
    If ReOriginal = True Then
        Me.Caption = "Rechnungsoriginal [" & Text & "]"
    Else
        Me.Caption = "Rechnungskopie [" & Text & "]"
    End If
    
    DoCmd.Close acForm, "Bitte_warten", acSaveYes

End Sub

Private Sub Report_Open(Cancel As Integer)
    SchriftartFuerBerichtEinstellen Me
    
    'berschrift fr Dauer einstellen
    Select Case FormatTermindauer
        Case 0      'Minuten  (Bsp.: 105)
            Me.Dauer_Bezeichnungsfeld.Caption = "Minuten/Stck."
        Case 4      'Dezimalstunden  (1,75)
            Me.Dauer_Bezeichnungsfeld.Caption = "Std/Stck."
        Case 8      'Std:Min  (01:45)
            Me.Dauer_Bezeichnungsfeld.Caption = "Std:Min/Stck."
        Case Else
            Me.Dauer_Bezeichnungsfeld.Caption = "Minuten/Stck."
    End Select
    
    '***KOPIE***
    If ReOriginal = True Then
        Me.KopieMarker.Visible = False
    Else
        Me.KopieMarker.Visible = True
    End If
    
End Sub
